/*
 * CGen2TagMinimumPowerMeasurement.h
 *
 *  Created on: 05.05.2011
 *      Author: stefan.detter
 */

#ifndef CGEN2TAGMINIMUMPOWERMEASUREMENT_H_
#define CGEN2TAGMINIMUMPOWERMEASUREMENT_H_

#include "../../../ui/TabWidget.h"
#include "../../../ui/ConfigDialog.h"
#include <ui_CGen2TagMinimumPowerMeasurement.h>

#include <QSet>

class QrfeReaderInterface;
class QrfeTagInterface;
class QrfeGen2Tag;

class QStandardItemModel;
class QwtPlot;
class QwtPlotCurve;


class CGen2TagMinimumPowerMeasurement : public TagTabWidget, ConfigDialog
{
	Q_OBJECT

public:
	CGen2TagMinimumPowerMeasurement(QTextEdit* infoEdit, QWidget* parent);
	virtual ~CGen2TagMinimumPowerMeasurement();

	virtual bool init(QrfeReaderInterface* reader, QrfeTagInterface* tag);
	virtual void deinit();

	virtual bool hasExecutionCount();

private slots:
	void startButtonClicked();

	void runFrequencySweep();
	void clearValues();
	void sweepValuesChanged ( );

	void cyclicInventory(const QrfeGlobal::TagReadEvent& tag);

	void exportSweepResults();

private:
	void measureReflectedPowerValue(ulong freq, ushort time, ushort att, double &dBm, double &ival, double &qval);
	void measureMinimumPower(ulong freq, ushort startAtt, ushort stopAtt, ushort stepsAtt, int timeout, ushort& maxAtt);

	void reloadLicenseData();

private:
	QrfeReaderInterface* 					m_reader;
	QrfeGen2Tag*							m_tag;
	QWidget* 								m_parent;

	QStandardItemModel*					m_freqSweepValueModel;
	QwtPlot*							m_freqSweepPlot;
	QwtPlotCurve*						m_reflectedPowerCurve;
	QwtPlotCurve*						m_minimumPowerCurve;

	bool								m_measurementActive;
	bool 								m_continueMeasurement;

	QSet<QString>						m_tagList;

	Ui::CGen2TagMinimumPowerMeasurement	ui;
};

#endif /* CGEN2TAGMINIMUMPOWERMEASUREMENT_H_ */
